//Operating system: Windows 8
////SCILAB Ver: 5.5.2
//Experiment No. 5
//Solver required: Stixbox: Version 2.3-1
//Objective: Determination of Polynomial fit, Analyzing Residuals, exponential fit & error bounds form the given data

//census is the given input data of year and population for the experiment no 5
//Output provides three figure.....
//figure(1) for Polynomial fit and Analyzing Residuals 
//figure (2) for exponential fit  and Analyzing Residuals 
//and figure (3) for error bounds


clc
clear all
census=[1901 238396327;
1911	252093390;
1921	251321213;
1931	278977238;
1941	318660580;
1951	361088090;
1961	439234771;
1971	548159652;
1981	683329097;
1991	846421039;
2001	1028737436;
2011	1210854977]
year = census(:,1);
pop = census(:,2)./1000000;


//Normalisation of data 
syear = (year-mean(year))./stdev(year);

//Fit the data in 1 deg polynomial
A1 = polyfit(syear,pop,1);
P=polyval(A1,syear);
figure(1)
subplot(2,2,1)
plot(year,pop,'-',year,P,'+')
title('Polyfit of data')
xlabel('Year')
ylabel('population(in millions)')
set(gca(),"grid",[1 1])

//Analyzing Residuals
res1 = pop-P;
subplot(2,2,2)
plot(year,res1,'r*')
title('res of data')
xlabel('Year')
ylabel('res(in millions)')
set(gca(),"grid",[1 1])
subplot(2,2,4)

//Fit the data in 4 deg polynomial
A2 = polyfit(syear,pop,4);
P1=polyval(A2,syear);
subplot(2,2,3)
plot(year,pop,'-',year,P1,'+')
title('Polyfit of data')
xlabel('Year')
ylabel('population(in millions)')
set(gca(),"grid",[1 1])


//Analyzing Residuals
res2 = pop-P1;
subplot(2,2,4)
plot(year,res2,'r*')
title('res of data')
xlabel('Year')
ylabel('res(in millions)')
set(gca(),"grid",[1 1]) //for grid on


//Exponential Fit 1 degree polynomial
figure(2)
subplot(2,2,1)
log1 = polyfit(syear,log10(pop),1);
logr1 = 10.^polyval(log1,syear);
plot2d1("oll",year,[logr1 pop])
title('Plot of Exp Fit')
ylabel('Population(in millions)')
xlabel('Year')
set(gca(),"grid",[1 1])

//Analyzing the residuals
logr1 = polyval(log1,syear);
res1 = log10(pop)-logr1;
subplot(2,2,2)

plot(year,res1,'r*')
title('Plot of Residuals')
ylabel('Residuals(in millions)')
xlabel('Year')
set(gca(),"grid",[1 1])

//Exponential Fit 4 degree polynomial
log1 = polyfit(syear,log10(pop),4);
logr1 = 10.^polyval(log1,syear);
subplot(2,2,3)
title('Plot of Exp Fit')
plot2d1("oll",year,[logr1 pop])
ylabel('Population(in millions)')
xlabel('Year')
set(gca(),"grid",[1 1])

//Analyzing the residuals
logr1 = polyval(log1,syear);
res1 = log10(pop)-logr1;
subplot(2,2,4)
plot(year,res1,'r*')
title('Plot of Residuals')
ylabel('Residuals(in millions)')
xlabel('Year')
set(gca(),"grid",[1 1])


//%Error Bound

figure(3)
[p2,s2] = polyfit(syear,pop,2);
[pop2,del2] = polyval(p2,syear,s2);
plot(year,pop,'+',year,pop2,'-',year,pop2+2*del2,'*:',year,pop2-2*del2,'r:')
ylabel('Population(in millions)')
xlabel('Year')
set(gca(),"grid",[1 1])
